<?php
use RobRichards\XMLSecLibs\XMLSecurityKey;
use RobRichards\XMLSecLibs\XMLSecurityDSig;

require_once __DIR__ . '/../vendor/autoload.php';

/**
 * Envia lote GNRE via SOAP 2.00
 * 
 * @param string $signedXml XML assinado
 * @param string $pfxPath Caminho do certificado PFX
 * @param string $pfxPassword Senha do PFX
 * @param bool $ambiente_producao true = produÃ§Ã£o | false = homologaÃ§Ã£o
 */
function enviar_gnre2_soap($signedXml, $pfxPath, $pfxPassword, $ambiente_producao = false)
{
    // ðŸ”¹ Endpoint: sempre o mesmo domÃ­nio, muda sÃ³ o ambiente no XML
    $endpoint = 'https://www.gnre.pe.gov.br/gnreWS/services/GnreLoteRecepcao';

    // ðŸ”¹ Remove cabeÃ§alho XML
    $signedXml = preg_replace('/<\?xml.*?\?>/', '', trim($signedXml));

    // ðŸ”¹ Garante namespace da GNRE
    if (!str_contains($signedXml, 'xmlns="http://www.gnre.pe.gov.br"')) {
        $signedXml = preg_replace(
            '/<TLote_GNRE(.*?)>/',
            '<TLote_GNRE xmlns="http://www.gnre.pe.gov.br"$1>',
            $signedXml
        );
    }

    // ðŸ”¹ ForÃ§a o campo ambiente (1=prod | 2=homologaÃ§Ã£o)
    $ambiente = $ambiente_producao ? '1' : '2';
    if (!str_contains($signedXml, '<ambiente>')) {
        $signedXml = preg_replace(
            '/<\/TLote_GNRE>/',
            "<ambiente>{$ambiente}</ambiente></TLote_GNRE>",
            $signedXml
        );
    } else {
        $signedXml = preg_replace('/<ambiente>.*?<\/ambiente>/', "<ambiente>{$ambiente}</ambiente>", $signedXml);
    }

    // ðŸ”¹ Monta envelope SOAP conforme WSDL oficial
    $soapEnvelope = '<?xml version="1.0" encoding="UTF-8"?>'
        . '<soap12:Envelope xmlns:soap12="http://www.w3.org/2003/05/soap-envelope" '
        . 'xmlns:gnre="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao">'
        . '<soap12:Header>'
        . '<gnre:gnreCabecMsg>'
        . '<gnre:versaoDados>2.00</gnre:versaoDados>'
        . '</gnre:gnreCabecMsg>'
        . '</soap12:Header>'
        . '<soap12:Body>'
        . '<gnre:gnreDadosMsg>'
        . $signedXml
        . '</gnre:gnreDadosMsg>'
        . '</soap12:Body>'
        . '</soap12:Envelope>';

    // ðŸ”¹ Log do envelope enviado
    $logDir = __DIR__ . '/../logs/envelope';
    if (!file_exists($logDir)) mkdir($logDir, 0777, true);
    $logFile = $logDir . '/envelope_' . date('Ymd_His') . '.xml';
    file_put_contents($logFile, $soapEnvelope);

    // ðŸ”¹ LÃª certificado
    $pfx = file_get_contents($pfxPath);
    if (!openssl_pkcs12_read($pfx, $certs, $pfxPassword)) {
        return [
            'sucesso' => false,
            'mensagem' => 'Falha ao ler o certificado PFX.'
        ];
    }

    // ðŸ”¹ Configura cURL
    $ch = curl_init($endpoint);
/*    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $soapEnvelope,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/soap+xml; charset=utf-8; action="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao/processar"',
            'Host: www.gnre.pe.gov.br'
        ],
        CURLOPT_SSLCERTTYPE => 'P12',
        CURLOPT_SSLCERT => $pfxPath,
        CURLOPT_SSLCERTPASSWD => $pfxPassword,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_CONNECTTIMEOUT => 30,
        CURLOPT_TIMEOUT => 60,
        CURLOPT_VERBOSE => false
    ]);*/
    // 🔹 Ajuste para ambiente de homologação
if (!$ambiente_producao) {
    // IP fixo do servidor da GNRE (obtido via nslookup)
    curl_setopt($ch, CURLOPT_RESOLVE, ['www.testegnre.pe.gov.br:444:200.238.99.68']);
    // Força o Host correto, mas ignora SSL inválido
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Host: www.testegnre.pe.gov.br',
        'Content-Type: application/soap+xml; charset=utf-8; action="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao/processar"'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
}


    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $errno = curl_errno($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // ðŸ”¹ Salva resposta
    $respLog = __DIR__ . '/../logs/retornos/retorno_' . date('Ymd_His') . '.xml';
    if (!file_exists(dirname($respLog))) mkdir(dirname($respLog), 0777, true);
    file_put_contents($respLog, $response ?: $error);

    // ðŸ”¹ Trata erros
    if ($errno) {
        return [
            'sucesso' => false,
            'mensagem' => "Erro cURL ($errno): $error",
            'endpoint' => $endpoint,
            'log' => $respLog
        ];
    }

    if ($info['http_code'] != 200) {
        return [
            'sucesso' => false,
            'mensagem' => "Falha HTTP {$info['http_code']} ao enviar GNRE",
            'endpoint' => $endpoint,
            'response' => strip_tags($response)
        ];
    }

    // ðŸ”¹ Retorno OK
    return [
        'sucesso' => true,
        'mensagem' => 'GNRE enviada com sucesso!',
        'endpoint' => $endpoint,
        'response' => $response,
        'log' => $respLog
    ];
}
?>
